//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace LicensedControl
{
	/// <summary>
	/// Podsumowanie dla UserControl.
	/// </summary>
	[LicenseProvider(typeof(LicFileLicenseProvider))]
	public class UserControl : System.Windows.Forms.UserControl
	{
		private License license = null;
		private System.Windows.Forms.Label label;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public UserControl()
		{
			// Dodanie Validate do konstruktora elementu sterujcego.
			license = LicenseManager.Validate(typeof(UserControl), this);

			// To wywoanie jest wymagane przez Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Dodanie inicjalizacji po wywoaniu InitForm.

		}

		public new string Text
		{
			get
			{
				return label.Text;
			}
			set
			{
				label.Text = value;
			}
		}
		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if( components != null )
					components.Dispose();
				if (license != null) 
				{
					license.Dispose();
					license = null;
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.label = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// label
			// 
			this.label.Location = new System.Drawing.Point(16, 16);
			this.label.Name = "label";
			this.label.Size = new System.Drawing.Size(200, 16);
			this.label.TabIndex = 0;
			this.label.Text = "Wasny element sterujcy";
			this.label.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// UserControl
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.label});
			this.Name = "UserControl";
			this.Size = new System.Drawing.Size(232, 48);
			this.ResumeLayout(false);

		}
		#endregion
	}
}
